<?php
/**
 * ServiceProvider.php 2020-10-19
 * Gambio GmbH
 * http://www.gambio.de
 * Copyright (c) 2020 Gambio GmbH
 * Released under the GNU General Public License (Version 2)
 * [http://www.gnu.org/licenses/gpl-2.0.html]
 */

declare(strict_types=1);

namespace Gambio\Shop\Product\Representation\ShortDescription;

use Doctrine\DBAL\Connection;
use Gambio\Core\Application\DependencyInjection\AbstractBootableServiceProvider;
use Gambio\Core\Event\EventListenerProvider;
use Gambio\Shop\Product\Representation\ShortDescription\Listener\OnGetShortDescriptionEventListener;
use Gambio\Shop\Product\Representation\ShortDescription\Repository\Readers\Reader;
use Gambio\Shop\Product\Representation\ShortDescription\Repository\Readers\ReaderInterface;
use Gambio\Shop\Product\Representation\ShortDescription\Repository\Repository;
use Gambio\Shop\Product\Representation\ShortDescription\Repository\RepositoryInterface;
use Gambio\Shop\SellingUnit\Presentation\Events\OnGetShortDescriptionEvent;

/**
 * Class ServiceProvider
 *
 * @package Gambio\Shop\Product\Representation\ShortDescription
 */
class ServiceProvider extends AbstractBootableServiceProvider
{
    /**
     * @var string[]
     */
    public function provides(): array
    {
        return [
            OnGetShortDescriptionEventListener::class
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->registerShared(OnGetShortDescriptionEventListener::class)
            ->addArgument(ReadServiceInterface::class);
        $this->application->registerShared(ReadServiceInterface::class, ReadService::class)
            ->addArgument(RepositoryInterface::class);
        $this->application->registerShared(RepositoryInterface::class, Repository::class)
            ->addArgument(ReaderInterface::class);
        $this->application->registerShared(ReaderInterface::class, Reader::class)->addArgument(Connection::class);
    }
    
    
    /**
     * @inheritDoc
     */
    public function boot(): void
    {
        /** @var EventListenerProvider $listenerProvider */
        $listenerProvider = $this->application->get(EventListenerProvider::class);
        $listenerProvider->attachListener(OnGetShortDescriptionEvent::class, OnGetShortDescriptionEventListener::class);
    }
}